<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\commissionSave;
use App\Models\referredDist;
use Illuminate\Pagination\LengthAwarePaginator;



class UserReferralController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    // public function index()
    // {
    //     $title = "Referral Link";
    //     $datas = User::where('rfered_by', Auth::user()->id)->get();
    //     // return $datas;
    //     return view('user.pages.referral', compact('title', 'datas'));
    // }
  public function index()
{
    $maxGeneration = referredDist::max('generation');

    $title = "Referral Link";
    $userId = Auth::user()->id;

    // Fetch referral generations and count total generations
    $referrals = $this->getReferralGenerations($userId); // Call the helper method
    $totalGenerations = count($referrals); // Count the number of generations

    // Calculate total referral income from the relevant columns
    $user = Auth::user();
    $totalReferralIncome = $user->deposit_commision_from_refer 
                         + $user->earning_commision_from_refer 
                         + $user->verify_commision_from_refer;
                         

    return view('user.pages.referral', compact('title', 'referrals', 'totalGenerations', 'totalReferralIncome', 'maxGeneration'));
}

private function getReferralGenerations($userId)
{
    $referrals = [];
    $generation = 1;

    // Start fetching the first generation referrals with pagination
    $currentGeneration = User::where('rfered_by', $userId)->paginate(1000000); // Paginate 10 referrals per page

    while ($currentGeneration->isNotEmpty()) {
        // Store current generation referrals
        $referrals[$generation] = $currentGeneration->map(function ($user) use ($generation) {
            return [
                'id' => $user->id,
                'code' => $user->code,
                'name' => $user->name,
                'premium_status' => $user->premium_status,
                'joined_date' => $user->created_at->format('d M, Y'),
                'generation' => $generation,
                'children' => [] // Placeholder for children (sub-referrals)
            ];
        })->toArray();

        // Fetch referrals for the next generation with pagination
        $currentGeneration = User::whereIn('rfered_by', $currentGeneration->pluck('id'))->paginate(1000000); // Paginate 10 referrals per page
        $generation++;
    }

    // Now populate the 'children' field with nested referrals for each generation
    foreach ($referrals as $gen => $generationData) {
        foreach ($generationData as $index => $user) {
            $userId = $user['id'];
            $user['children'] = $this->getReferralGenerationsForUser($userId);
            $referrals[$gen][$index] = $user;
        }
    }

    return $referrals;
}

// Helper method to fetch the referrals for a specific user (child generation) with pagination
private function getReferralGenerationsForUser($userId)
{
    $children = [];
    $currentGeneration = User::where('rfered_by', $userId)->paginate(1000000); // Paginate 5 children per page

    foreach ($currentGeneration as $user) {
        $children[] = [
            'id' => $user->id,
            'code' => $user->code,
            'name' => $user->name,
            'premium_status' => $user->premium_status,
            'joined_date' => $user->created_at->format('d M, Y'),
            'generation' => 'Child', // Indicating it's a child
            'children' => [] // Placeholder for further nested referrals
        ];
    }

    return $children;
}


    public function view_list()
    {
        $title = "Referral Users";
        // $datas = User::where('rfered_by', Auth::user()->id)->latest()->take(400)->get();
        $datas = User::where('rfered_by', Auth::user()->id)->get();
        // return $datas;
        return view('user.pages.referral-user', compact('title', 'datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
